
function AISMN_Work::OnEnter(%this, %data)
{
   %workplace = GetWorkplace(%data);
   if (%workplace == 0)
   {
      return;
   }

   %component = slgQueryInterface(%workplace, $CID_BUILDING);
   //If there's no component, report an error. 
   if (!%component)
   {
      return;
   }
   
   %animation = %component.getWorkAnimation();
   if (strlen(%animation) == 0)
   {
      return;
   }
   
   %object = GetThisObject(%data);
   %object.stopAnimation = true;
   %object.playThread(0, %animation);
}

function AISMN_Work::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %workplace = GetWorkplace(%data);
   if (isObject(%workplace) == true)
   {
      %workplace.unoccupyHotSpot(%object);
   }
   
   if (isObject(%workplace) == false || %object.stopAnimation == true)
   {
      %object.playThread( 0, "root");
   }
}

//EXIT 0: ERROR
//EXIT 1: NO ANIMATION AVAILABLE
//EXIT 2: WORKPLACE DOES NOT EXIST (could have been destroyed)
//EXIT 3: DONE WORKING
function AISMN_Work::Update(%this,%data)
{
   //Does the workplace still exist?
   %workplace = GetWorkplace(%data);
   if (%workplace == 0)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   //Are we done working here?
   if (TimeInNode(%data) > 10.0)
   {
      %object = GetThisObject(%data);
      %object.stopAnimation = false;
      ReturnValue(%data, 0);
      return;
   }
   
   //Stay in this state
   ReturnValue(%data, -1);
}
